/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.emi;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriClientApi;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.util.LangUtils;
import com.agricraft.agricraft.compat.emi.AgriCraftEmiPlugin;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CropProduceRecipe
implements EmiRecipe {
    public static final EmiTexture BACKGROUND = new EmiTexture(new class_2960("agricraft", "textures/gui/jei/crop_produce.png"), 0, 0, 128, 128, 128, 128, 128, 128);
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final AgriPlant plant;
    private final List<EmiStack> output;

    public CropProduceRecipe(class_2960 id, AgriPlant plant) {
        this.id = id;
        this.input = List.of(EmiStack.of((class_1799)AgriSeedItem.toStack(plant)).comparison(AgriCraftEmiPlugin.compareSeeds()));
        this.plant = plant;
        this.output = new ArrayList<EmiStack>();
        plant.getAllPossibleProducts(product -> this.output.add(EmiStack.of((class_1799)product).comparison(Comparison.compareNbt())));
    }

    public EmiRecipeCategory getCategory() {
        return AgriCraftEmiPlugin.PRODUCE_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 128;
    }

    public int getDisplayHeight() {
        return 128;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0);
        widgets.addSlot(this.input.get(0), 15, 8);
        widgets.addDrawable(16, 49, 16, 16, (draw, mouseX, mouseY, delta) -> {
            Optional<class_2960> optional = AgriApi.getPlantId(this.plant);
            if (optional.isPresent()) {
                class_2960 plantId = optional.get();
                draw.method_25298(0, 0, 0, 16, 16, AgriClientApi.getPlantModel(plantId.toString(), this.plant.getInitialGrowthStage().total() - 1).method_4711());
            }
        });
        ArrayList list = new ArrayList();
        AgriApi.getPlantId(this.plant).map(class_2960::toString).ifPresent(id -> {
            list.add(LangUtils.plantName(id));
            class_2561 desc = LangUtils.plantDescription(id);
            if (desc != null) {
                list.add(desc);
            }
        });
        widgets.addTooltipText(list, 16, 49, 16, 16);
        int index = 0;
        for (int y = 32; y < 83 && index < this.output.size(); y += 18) {
            for (int x = 74; x < 129 && index < this.output.size(); ++index, x += 18) {
                widgets.addSlot((EmiIngredient)this.output.get(index), x, y).drawBack(false).recipeContext((EmiRecipe)this);
            }
        }
    }
}

